LabeledButton = copy_table(Button)

function LabeledButton:init(def, view)
    Button.init(self, def, view)
    self.text = def.text
    self.text_shift_x = def.text_shift_x or 0
    self.text_shift_y = def.text_shift_y or 0
    self.font = def.font or "hud18"
end


function LabeledButton:destroy()
    Button.destroy(self)
end


function LabeledButton:set_text(text)
    self.text = text
end


function LabeledButton:render()
    Button.render(self)
    gfx_render_text(self.font, self.x + self.text_shift_x, self.y + self.text_shift_y, self.text, "center vcenter", nil, nil, 1, self.color)
end
